
markup.push({

	// -------------------------------------------------
	// MARK: pan

	PanBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Pan",
		geNodeClass: "AHPanNode",
		h4PresetsId: "PanPresets",
		gxPopoverInfo: "PanPopover",
		gxLibraryDescription: "Direct audio to the left or right channels",
		gxLibraryIcon: "library.pan",
		gxDescriptionKeyPath: "node.pan",
		gxDescriptionFormatter: "LeftRightFormatter",
		geImporterParams: ["node.importPan"],
		gxChildViews:
		{
			pan: {
				"+": "SliderView.blockFace.trackUnfilled",
				gxValueKey: "node.pan",
				gxRangeMin: -1,
				gxRangeMax: 1,
				gxDetents: "(0)",
				gxKeystrokeStepSize: 0.01,
				axTitle: "Pan",
				axFormatter: "PercentFormatter",
				axHelp: "Negative % is Left, Positive is Right",
			},
			readout: {
				"+": "LabelView.blockReadout",
				gxFrameRect: "18,66,83,25",
				gxValueKey: "node.pan",
				gxFormatter: "LeftRightFormatter"
			}
		}
	},
		
	// MARK: popover

	PanPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Pan",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group:
			{
				"+": "GroupView",
				gxLayout: [
					"H:|-0-[self]-0-|",
					"H:|-12-[pan]-12-|",
					"V:|-30-[pan]-16-|",

					"V:[leftLabel]-(-1)-[pan]&alignLeft",
					"V:[panReadout]-(-1)-[pan]&alignCenterX",
					"V:[rightLabel]-(-1)-[pan]&alignRight",
				],
				gxChildViews:
				{
					pan: {
						"+": "SliderView.trackUnfilled",
						gxValueKey: "node.pan",
						gxRangeMin: -1,
						gxRangeMax: 1,
						gxDetents: "0",
						gxKeystrokeStepSize: 0.01,
						axTitle: "Pan",
						axFormatter: "PercentFormatter",
						axHelp: "Negative % is Left, Positive is Right",
					},
					leftLabel: labelView("L", "size12"),
					rightLabel: labelView("R", "right.size12"), // "Right", right aligned
					panReadout: {
						"+": "ReadoutView.centerx",
						gxIntrinsicWidth: 100,
						gxValueKey: "node.pan",
						gxFormatter: "LeftRightFormatter.fullWords"
					}
				}
			}
		}
	},
		

})
